// copyright 2000 Eric Gunnerson
using System;
public class AngstromFormatter: IServiceObjectProvider, ICustomFormatter
{
    public object GetServiceObject(Type service)
    {
        if (service == typeof(ICustomFormatter)) 
        return this;
        else
        return null;
    }
    public string Format(string format, object arg, 
    IServiceObjectProvider sop)
    {
        if (format == null)
        return(String.Format("{0}", arg));
        
        if (format.StartsWith("Ang"))
        {
            extract any extra formatting information
            after "Ang" here
            string extra = "";
            
            if (arg is float)
            {
                float f = (float) arg;
                f *= 1.0E10F;
            return(String.Format("{0:" + extra + "}", f) + " ");
            }
            else if (arg is double)
            {
                double d = (double) arg;
                d *= 1.0E10D;
            return(String.Format("{0:" + extra + "}", d) + " ");
            }
        }
        not an object or format we support
    return(String.Format("{0:" + format + "}", arg));
    }
}
class Test
{
    public static void Main()
    {
        AngstromFormatter angstrom = new AngstromFormatter();
        
        Console.WriteLine("Meters: {0}", 1.35E-8F, angstrom);
    Console.WriteLine(String.Format("Angstroms: {0:Ang}", 
    new object[] {1.35E-8F}, angstrom));
    Console.WriteLine(String.Format("Angstroms: {0:Ang:g}", 
    new object[] {3.59393E-9D}, angstrom));
    }
}